/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.common.glyph.EffectMark;
import com.github.jarva.arsadditions.common.glyph.MethodRecall;
import com.github.jarva.arsadditions.common.glyph.MethodRetaliate;
import com.github.jarva.arsadditions.datagen.Setup;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class GlyphDatagen
extends GlyphRecipeProvider {
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public GlyphDatagen(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(generatorIn);
        this.lookupProvider = lookupProvider;
    }

    public void collectJsons(CachedOutput cache) {
        this.lookupProvider.thenAccept(provider -> this.addRecipe((AbstractSpellPart)MethodRetaliate.INSTANCE, this.i((ItemLike)Items.NETHERITE_SWORD), this.i(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(provider.holderOrThrow(Enchantments.THORNS), 3)))));
        this.addRecipe((AbstractSpellPart)MethodRecall.INSTANCE, this.i((ItemLike)ItemsRegistry.CONJURATION_ESSENCE), this.i((ItemLike)Items.ENDER_PEARL), this.i((ItemLike)ItemsRegistry.SCRYER_SCROLL), this.i((ItemLike)ItemsRegistry.SCRY_CASTER));
        this.addRecipe((AbstractSpellPart)EffectMark.INSTANCE, this.i((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE), this.i((ItemLike)Items.ENDER_PEARL), this.i((ItemLike)BlockRegistry.MOB_JAR), this.i((ItemLike)RitualRegistry.getRitualItemMap().get(ArsNouveau.prefix((String)RitualLib.CONTAINMENT))));
        for (GlyphRecipe recipe : this.recipes) {
            Path path = GlyphDatagen.getScribeGlyphPath(this.output, recipe.output.getItem());
            this.saveStable(cache, (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
        }
    }

    public Ingredient i(ItemLike item) {
        return Ingredient.of((ItemLike[])new ItemLike[]{item});
    }

    public Ingredient i(ItemStack item) {
        return Ingredient.of((ItemStack[])new ItemStack[]{item});
    }

    public void addRecipe(AbstractSpellPart part, Ingredient ... items) {
        GlyphRecipe recipe = this.get(part);
        for (Ingredient item : items) {
            recipe.withIngredient(item);
        }
        this.recipes.add(recipe);
    }

    protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
        return pathIn.resolve("data/" + Setup.root + "/recipe/" + RegistryHelper.getRegistryName((Item)glyph).getPath() + ".json");
    }
}

